package demo;

import java.io.*;
import java.util.*;
import javax.microedition.io.*;
import demo.data.Info;
import de.kxml.kdom.*;
import de.kxml.parser.*;

/**
 * Appelle les services distants HTTP
 */
public class RemoteServices {
  // URLs des services distants
  // Rcupre le nom de l'information qui satisfait la requte
  private static final String RESULT_SERVICE = "http://j2me.netinnovations.fr:9000/Result.po";
  // Rcupre les informations sur une information spcifique
  private static final String DETAILS_SERVICE = "http://j2me.netinnovations.fr:9000/Details.po";
  // Instante InstanceSingleton
  private static RemoteServices instance;

  // Constructeur crant le contrle
  protected RemoteServices() {
  }

  // Mthodes Singleton

  /**
   * Rcupre l'instance de Singleton
   */
  public static RemoteServices getInstance() {
    if (instance == null) return new RemoteServices();
    return instance;
  }

  // Fonctions distantes

  /**
   * Effectue une requte d'information  partir du type, du titre 
   * et d'une partie de son contenu
   * Retourne le rsultat de la requte sous forme de Vecteur 
   * d'objets InfoLink
   * Les paramtres sont type, titre et contenu
   */
  public Vector getResults(String type, String titre, String contenu) 
         throws IOException {
    HttpConnection con = null;
    InputStream in = null;
    Document document = null;
    try {
      StringBuffer queryURL = new StringBuffer(RESULT_SERVICE);
      queryURL.append("?type=");
      queryURL.append(type);
      queryURL.append("&titre=");
      queryURL.append(titre);
      queryURL.append("&contenu=");
      queryURL.append(contenu);
      con = (HttpConnection) Connector.open(queryURL.toString(), Connector.READ, true);
      con.setRequestMethod(HttpConnection.GET);
      con.setRequestProperty("Accept", "text/xml");
      con.setRequestProperty("Content-Language", "en-US");
      in = con.openInputStream();
      Parser parser = new DefaultParser(new InputStreamReader(in));
      document = new Document();
      document.parse(parser);
      Vector infoLinks = XMLServices.getInstance().deserializeInfoLinks(document);
      return infoLinks;
    } finally {
      if (in != null) in.close();
      if (con != null) con.close();
    }
  }

  /**
   * Rcupre dans la base de donnes les dtails d'une informations particulire  partir de son oid
   * Retourne l'objet Info correspondant
   * Le paramtre est id
   */
  public Info getDetails(String oid)
         throws IOException {
    HttpConnection con = null;
    InputStream in = null;
    Document document = null;
    try {
      StringBuffer detailsURL = new StringBuffer(DETAILS_SERVICE);
      detailsURL.append("?id=");
      detailsURL.append(oid);
      con = (HttpConnection) Connector.open(detailsURL.toString(), Connector.READ, true);
      con.setRequestMethod(HttpConnection.GET);
      con.setRequestProperty("Accept", "text/xml");
      con.setRequestProperty("Content-Language", "en-US");
      in = con.openInputStream();
      Parser parser = new DefaultParser(new InputStreamReader(in));
      document = new Document();
      document.parse(parser);
      Info p = XMLServices.getInstance().deserializeInfo(document);
      return p;
    } finally {
      if (in != null) in.close();
      if (con != null) con.close();
    }
  }
}
